@echo off
color 1E
REM ti99dir.bat 20231224
REM
REM Batch file to be used with TotalCommander (https://www.ghisler.com/)
REM for starting Ti99Dir. Either one or two directories or TI DSK iamges can be
REM selected in TotalCommander before starting Ti99Dir.
REM
REM Button configuration:
REM
REM Command          : C:\Ti994w\Utl\Ti99dir.bat
REM Parameters       : %C1 %C2 %p%n
REM Working directory: C:\Ti994w\Utl\
REM Program pictogram: C:\Ti994w\Utl\Ti99dir.exe
REM
REM echo.
REM echo. TTTTTTT III  9999   9999    DDDDDD  III RRRRR 
REM echo.    T     I  9    9 9    9    D    D  I   R   R
REM echo.    T     I  9    9 9    9    D    D  I   R   R
REM echo.    T     I   99999  99999    D    D  I   RRRR 
REM echo.    T     I       9      9    D    D  I   R   R
REM echo.    T     I       9      9    D    D  I   R   R
REM echo.    T    III  9999   9999    DDDDDD  III  R   RR
REM echo.
REM echo.
REM echo. https://www.patorjk.com/software/taag
type %~n0.ttl

set ARG1=%~1
set ARG2=%~2
set ARG3=%~3
set RES=
set EXT=

call :DREMUPR ARG1 "%ARG1%"
call :DREMUPR ARG2 "%ARG2%"
call :DREMUPR ARG3 "%ARG3%"

call :FDEXIST ARG1 "%ARG1%"
call :FDEXIST ARG2 "%ARG2%"
call :FDEXIST ARG3 "%ARG3%"

if not "%ARG1%"=="" goto CHK2
set ARG1=%ARG2%
set ARG2=%ARG3%
set ARG3=

:CHK2
if not "%ARG2%"=="" goto CHK3
set ARG2=%ARG3%
set ARG3=

:CHK3
echo checked2
echo ARG1: [%ARG1%]
echo ARG2: [%ARG2%]
echo ARG3: [%ARG3%]
rem pause

:ARG1
if exist "%ARG1%\*" goto ARG2
CALL :GETEXT EXT "%ARG1%"
if "%EXT%"==".dsk" goto ARG2
if "%EXT%"==".DSK" goto ARG2
if "%EXT%"==".img" goto ARG2
if "%EXT%"==".IMG" goto ARG2
if "%EXT%"==".cf7" goto ARG2
if "%EXT%"==".CF7" goto ARG2
goto ERROR

:ARG2
if "%ARG2%"==""     goto TI99DIR1
if exist "%ARG2%\*" goto TI99DIR2
CALL :GETEXT EXT "%ARG2%"
if "%EXT%"==".dsk" goto TI99DIR2
if "%EXT%"==".DSK" goto TI99DIR2
if "%EXT%"==".img" goto TI99DIR2
if "%EXT%"==".IMG" goto TI99DIR2
if "%EXT%"==".cf7" goto TI99DIR2
if "%EXT%"==".CF7" goto TI99DIR2
goto TI99DIR1

:ERROR
color 4e
@choice /M "Wrong type of file for Ti99Dir ..." /C x /D x /N /T 2
goto END

:TI99DIR1
echo result1
echo [%ARG1%]
echo  .\TI99DIR.EXE -L "%ARG1%" -S-
start .\TI99DIR.EXE -L "%ARG1%" -S-
goto END

:TI99DIR2
echo result2
echo [%ARG1%]
echo [%ARG2%]
echo  .\TI99DIR.EXE -L "%ARG1%" -R "%ARG2%" -S-
start .\TI99DIR.EXE -L "%ARG1%" -R "%ARG2%" -S-
goto END


REM Set variable value without quotes
REM %1 variable name
REM %2 value
:UNQUOTE
set %1=%~2
exit /b 0


REM Remove upper directory "\.." from the string
REM Remove this  directory "\."  from the string
REM Remove ending backslash "\"  from the string
REM %1 variable name
REM %2 directory string
:DREMUPR
set RES=%~2
if "%RES:~-1%"=="." set RES=%RES:~0,-1%
if "%RES:~-1%"=="." set RES=%RES:~0,-1%
if "%RES:~-1%"=="\" set RES=%RES:~0,-1%
set %1=%RES%
exit /b 0


REM Check if File or Directory exists
REM %1 variable name
REM %2 directory string
:FDEXIST
if exist "%~2"     goto XIST
if exist "%~2\NUL" goto XIST
set %1=
exit /b 1
:XIST
set %1=%~2
exit /b 0


REM Get the extension of a file name
REM %1 variable name
REM %2 [path\]filename.ext
:GETEXT
set %1=%~x2
exit /b 0

:END