********************************************************************************
*                        COM1$ INTERFACE CARD ROMS                             *
*------------------------------------------------------------------------------*
       DEF  SFIRST,SLAST 
*==============================================================================*
* 9900 assembly language routines     Stored in ROM at >4000-48B0              *
* -------------------------------                                              *
*==============================================================================*
COC    MACRO %1,%2
       DATA %2*64+>2020,%1
       ENDM
       AORG >4000

W      EQU  >0040
RBR    EQU  >5F80
THR    EQU  >5FC0
DLL    EQU  >5F80
DLM    EQU  >5F82
IER    EQU  >5F82
FCR    EQU  >5F84
IIR    EQU  >5FC0
LCR    EQU  >5F86
MCR    EQU  >5F88
LSR    EQU  >5F8A
MSR    EQU  >5F8C
SCR    EQU  >5F8E

TRG01  EQU  >00
TRG04  EQU  >40
TRG08  EQU  >80
TRG14  EQU  >C0

ERBI   EQU  >01
AFE    EQU  >20
RTS    EQU  >02
DTR    EQU  >01
TERI   EQU  >04
CTS    EQU  >10
DSR    EQU  >20
RI     EQU  >40
DCD    EQU  >80

DR     EQU  >01
OE     EQU  >02
PE     EQU  >04
FE     EQU  >08
BI     EQU  >10
THRE   EQU  >20
TEMT   EQU  >40

*
SFIRST DATA >AA01             version 1
       DATA >0000             no programs
HEX40  DATA PWRHD             power-up
       DATA >0000
       DATA DSRHD             dsr
       DATA >0000
       DATA INTHD             interrupt
       DATA >0000
*                             power-up header
PWRHD  DATA >0000             ---------------
       DATA PWRUP             address
       DATA >0000             no name
*
DSRHD  DATA >0000             dsr headers
       DATA COM1$             -----------
       BYTE 4
       TEXT 'COM1'
       EVEN
*                             interrupt header
INTHD  DATA >0000             ----------------
       DATA ISRTN             address
       DATA >0000             no name
*
H0008  BYTE >08
HEX00  BYTE >00
H0303  DATA >0303
*
OPTBL  TEXT 'EC'              options table
       DATA OP_EC             -------------
       TEXT 'CR'
       DATA OP_CR
       TEXT 'LF'
       DATA OP_LF
       TEXT 'NU'
       DATA OP_NU
       TEXT 'DA'
       DATA OP_DA
OPT10  TEXT 'BA'              for Save and Old: start here
       DATA OP_BA
       TEXT 'PA'
       DATA OP_PA
       TEXT 'TW'
       DATA OP_TW
       TEXT 'CH'
       DATA OP_CH
       DATA >0000
*
*                             nominal baud rates
BAUD$  DATA 110,4189              ------------------
       DATA 300,1536
       DATA 600,768
       DATA 1200,384
       DATA 2400,192
       DATA 4800,96
       DATA 9600,48
       DATA 19200,24
       DATA >3600,12         *38400
       DATA >E100,8          *57600
       DATA >C200,4          *115200
       DATA >0000
 
*------------------------------------------------------------------------------*
* Interrupt routine       &       Power-up routine                             *
* -----------------               ----------------                             *
* Checks if interrupt has been issued by this card (if not: returns),          *
*        if it came from receive buffer (if not: performs power-up).           *
*                                                                              *
* Saves the incoming character in a circular buffer in vdp memory              *
*        Buffer base adress in >8300->8301.                                    *
*        Max size in >8302 (following chars saved from bottom again).          *
*        Ptr to next char to read (by caller) in >8303.                        *
*        Ptr to last char written in >8304.                                    *
*                                                                              *
* In case of reception errors the byte is replaced with >FF.                   *
* If buffer is full (>8304 would equal >8303), the previous byte is replaced   *
* with >7E, the incoming one is lost.                                          *
*                                                                              *
* Interrupts are enabled by opcode >80 and disabled by i/o opcodes             *
*------------------------------------------------------------------------------*
ISRTN  STWP 4                 interrupt routine
*      SBO  7                 ----------------- lamp on
       MOV  11,5
       MOV  12,6
*      AI   12,>0040          cru of first COM1$ chip
*      TB   16                receive buffer interrupt?
       JEQ  ISR10             yes
*      TB   31                any interrupt at all?
*      JEQ  ISR05             yes
*      AI   12,>0040          no -> next chip
*      TB   16
*      JEQ  ISR10             receive buffer interrupt
*      TB   31
       JNE  ISR40             no interrupt in this card
ISR05  MOV  6,12              interrupt but not from reception

PWRUP  MOV  12,6              power-up
       MOVB @HEX06,@FCR+W    *RESET FIFOS
       RT

*                             interrupt from receive buffer
ISR10  BL   @RXRDY            test dsr pin and rec buffer
       JNE  ISR40             no reception
       MOVB @>FF24(4),1       >8304: write ptr
       AB   @HEX01,1          add >01
       CB   1,@>FF22(4)       >8302: max size
       JLE  ISR20
       CLR  1                 circle to buffer bottom
ISR20  CB   1,@>FF23(4)       >8303: read ptr
       JEQ  HFE00             overflow
*      STCR 7,8               fetch byte received
*      TB   9                 error?
*      JNE  ISR30             no
       MOVB @RBR,7           * fetch byte received
       MOVB @LSR,11          * GET ERROR FLAGS
       SWPB 11
       ANDI 11,OE+FE+PE
       JEQ  ISR30            * no ERRORS
       LI   7,>FF00           yes: use >FF as a flag
HFF00  EQU  $-2
       JMP  ISR30
HFE00  LI   7,>FE00           buffer overflow, use >FE as a flag
       MOVB @>FF24(4),1       place it over the previous byte (i.e. 2 bytes lost)
ISR30  MOVB 1,@>FF24(4)       >8304: write ptr
       SRL  1,8
       A    @>FF20(4),1       >8300: buffer base
       ANDI 1,>3FFF           make it a valid VDP address
       BL   @GTP10            set vdp address from r1
       DATA >4000             for a write
       MOVB 7,@>FFFE(15)      save byte in circular buffer
ISR40  EQU  $
*      SBO  18                reset flag, interrupt enabled
       MOV  6,12              card CRU base
*      SBZ  7                 lamp off
       B    *5
 
*------------------------------------------------------------------------------*
*  Device Service Routines DSR                                                 *
*  ---------------------------                                                 *
*                                                                              *
*  Special registers:                                                          *
*  R3:  >FFFF for PIO, >0000 for COM1$                                         *
*  R6:  >0001 for first card, >0002 for second                                 *
*  R9:  crc (cyclic redundancy check)                                          *
*  R12: CRU base: >1300 for card (pio), >1340 for COM1$/1 and >1380 for COM1$/2*
*                                                                              *
*  Scratch-pad map:                                                            *
*  >834A      opcode                                                           *
*  >834B      flags         |                                                  *
*  >834C-D    data buffer   |                                                  *
*  >834E      record length |copy of pab                                       *
*  >834F      char count    |(peripheral access block)                         *
*  >8350-1    record number |                                                  *
*  >8352      screen bias   |                                                  *
*  >8353      name length   |                                                  *
*  >8354-5    device name length                                               *
*  >8356-7    end of device name                                               *
*  >8358      .EC echo off          |                                          *
*  >8359      .CR no cr nor lf      |                                          *
*  >835A      .LF no line feed      |                                          *
*  >835B      .CH parity check      |flags                                     *
*  >835C      .NU add nulls         |                                          *
*  >835D      interrupt opcode (80) |                                          *
*  >835E-F    current rec number                                               *
*  >8360-1    current rec size                                                 *
*  >8362-3       (not used)                                                    *
*  >8364-D    5 buffers to save r11                                            *
*                                                                              *
*  >83DA-B    control register copy                                            *
*  >83DE-F    interval register copy                                           *
*------------------------------------------------------------------------------*
COM1$  LI   6,>0001           rs232 rs232/1
       LI   2,>0040
       CLR  3
       STWP 4                 save workspace (>83E0)
       MOV  11,@>FF84(4)      ret address in >8364
DSR30  MOV  4,6               |
       AI   6,>FF78           |
       LI   5,>0006           |clear >8358-8362 (flags)
HEX06  EQU  $-1
DSR35  CLR  *6+               |
       DEC  5                 |
       JNE  DSR35             |
*      SBO  7                 lamp on
       A    2,12
       BL   @GTPAB            |
       DATA >0000             |
       LI   5,>000A           |
       MOV  4,6               |copy pab (without name)
       AI   6,>FF6A           |in >834A->8353
DSR40  MOVB @>FBFE(15),*6+    |
       DEC  5                 |
       JNE  DSR40             |
       SZCB @HEXE0,@>FF6B(4)  >D0 : clear status
       CB   @HEX80,@>FF6A(4)  opcode = >80?
       JNE  DSR45
       SOCB @HFF00,@>FF7D(4)  >835D = >FF (interrupt flag)
       SZCB @HEX80,@>FF6A(4)  opcode -> open
DSR45  CB   @>FF6A(4),@HEX06  opcode bigger than >06?
       JLE  DSR50
       B    @ERR$3            yes -> err 3
DSR50  BL   @INIT$
       MOVB @>FF6A(4),5       |
       SRL  5,8               |
       MOV  5,@SCR+W         *|SAVE COPY OF SCRATCH
       SLA  5,1               |branch to opcode
       MOV  @CMDTB(5),5       |
       B    *5                |
*
CMDTB  DATA OPEN$             open
       DATA CLOSE             close ret
       DATA INPUT             input
       DATA PRINT             print
       DATA ERR$3             restore -> err 3
       DATA OLD$$             old
       DATA SAVE$             save
*-------------------------------------------------------------------------------
OPEN$  MOVB @>FF6E(4),2       open
       JNE  OPN10             ====
       BL   @GTPAB            |
       DATA >4004             |if rec len=0 (>834E)
       LI   2,>5000           |set default length (80)
       MOVB 2,@>FF6E(4)       |
       MOVB 2,@>FFFE(15)      |
OPN10  MOVB @>FF6B(4),1
HEX20  COC  H0100,1           relative?
       JNE  CFV40             no  -> return
       B    @ERR$2            yes -> err 2
*-------------------------------------------------------------------------------
*                             input
INPUT  ABS  3                 =====
       MOVB @HEX03,@MCR+W    *SET RTS(SIGNAL HOST TO TRANSMIT)
       SZCB @HFF00,@>FF6F(4)  clear char count  (>834F)
       MOVB @>FF6E(4),7       fetch rec len     (>834E)
       MOV  @>FF6C(4),9       fetch data buffer (>834C)
       BL   @IN$DS            int/dis?
       JNE  INP20            *dis
       BL   @RX1CH            int: fetch rec size from pio/rs232
       CB   7,6               check it
       JHE  INP10
       MOVB @HEX01,@MCR+W    *CLEAR RTS
       B    @ERR$4            too long -> err 4
INP10  MOV  6,7
INP20  SRL  7,8
       JEQ  CFV30             size=0 -> end
INP30  BL   @RX1CH            receive 1 char
       BL   @IN$DS            int/dis?
       JEQ  CFV20
       MOVB @>FF78(4),1       echo type
       JEQ  INP40             on
       BL   @FX$VR            off: fix/var?
       JEQ  CFV20             fixed
       CI   6,>0D00           var: check if end-of-record
       JNE  CFV20
       JMP  CFV30             end if <cr>
INP40  CI   6,>0D00           echo on
       JEQ  CRF$V             <cr>  (end of record)
       CI   6,>7F00           <del>
       JEQ  DELCH
       CI   6,>1200           <ff> (form feed)
       JNE  CFV10             others
       MOV  @>FF6C(4),1       <ff> |set data buffer address
       BL   @GTP20                 |for reading
       BL   @EOREC            end of rec
       MOV  9,2               |
       S    @>FF6C(4),2       |current size
       JMP  INP60
INP50  BL   @TX1VR            TRANSMIT 1 byte
       DEC  R2
INP60  JNE  INP50
       JMP  INP30
*
DELCH  C    @>FF6C(4),9       <del>
       JEQ  INP30             size=0
       INC  7                 |
       DEC  9                 |dec data pointer
       MOV  9,1
       BL   @GTP20            |
       BL   @TX1VR            |TRANSMIT previous char
       CI   6,>0D00
       JNE  INP30
       BL   @EOR10            if <cr> end of rec
       JMP  INP30
*
CRF$V  BL   @FX$VR            <cr> fix/var?
       JEQ  CFV10
       BL   @EOREC            var: end of rec
       JMP  CFV30             end
CFV10  BL   @TX1R6            fix: TRANSMIT char
HEXC0  EQU  $
CFV20  MOV  9,1               |
       BL   @GTP10            |
       DATA >4000             |put char in data buffer
       MOVB 6,@>FFFE(15)      |
       INC  9                 |
       DEC  7                 last?
       JNE  INP30
CFV30  MOVB @HEX01,@MCR+W    *CLEAR RTS(HOST SEES AS CTS)
       S    @>FF6C(4),9       |
       SLA  9,8               |calc char count
       MOVB 9,@>FF6F(4)       |
CFV40  JMP  PRN50             return
*-------------------------------------------------------------------------------
PRINT  EQU  $                 print
PRN10  MOV  @>FF6C(4),1       |set data buffer address
       BL   @GTP20            |to read
       MOVB @>FF6F(4),7       char count (>834F)
       BL   @IN$DS            int/dis?
       JNE  PRN20             dis
       MOV  7,6               |
       BL   @TX1R6            |int -> TRANSMIT size
PRN20  SRL  7,8
       JEQ  PRN40             size = 0
PRN30  BL   @TX1VR            TRANSMIT 1 byte
       DEC  7
       JNE  PRN30             next
PRN40  BL   @IN$DS            int/dis?
       JEQ  PRN50
       BL   @FX$VR            dis -> fix/var?
       JEQ  PRN50
       BL   @EOREC            var -> end of rec
PRN50  B    @CLOSE            return
*-------------------------------------------------------------------------------
*                             old
OLD$$  MOV  @>FF70(4),0       ===  size (>8350)
OLD10  BL   @TCHDT            |
       DATA >1600             |send <syn> (synchro)
       LI   5,>0007
OLD20  LI   1,>C01C
OLD30  MOVB @HEX03,@MCR+W    *SET RTS
       BL   @RXRDY            check dsr pin and rec buffer
       JEQ  OLD40
       DEC  1                 delay
       JNE  OLD30
       BL   @KBTST            test <clear> key
       DEC  5                 7 times
       JNE  OLD20
       JMP  OLD10             send <syn> again
OLD40  SETO 9                 reception. reset crc
       BL   @RXCRC            |
       MOV  6,7               |
       BL   @RXCRC            |fetch 2 bytes received
       SRL  6,8               |size (in bytes)
       SOC  6,7               |
       BL   @RX2CH            fetch 2 bytes, in r8
       BL   @PTN10            write rec number
       C    8,9               check crc
       JEQ  OLD45
       BL   @TCHDT            |wrong -> send <nak> (not acknowledged)
       DATA >1500             |and retry
       JMP  OLD40             |
OLD45  C    0,7               check size
       JL   ERR$4             too large -> err 4
       BL   @TCHDT            |
       DATA >0600             |send <ack> (acknoledged)
OLD50  BL   @NXREC            number of bytes
OLD55  SETO 9                 reset crc
       MOV  10,1
       BL   @GTP10            |set data buffer address
       DATA >4000             |for writing
OLD60  BL   @RXCRC            fetch 1 byte in r6
       MOVB 6,@>FFFE(15)
       DEC  7                 next
       JNE  OLD60
       BL   @RX2CH            fetch 2 bytes in r8
OLD65  C    9,8               check crc
       JEQ  OLD70
       MOV  @>FF80(4),7       >8360
       BL   @TCHDT            |
       DATA >1500             |send <nak>
       JMP  OLD55             |and retry
OLD70  BL   @TCHDT
       DATA >0600             send <ack>
       AI   10,>0100
H0100  EQU  $-2
       MOV  @>FF7E(4),7       retrieve rec number (>835E)
       JMP  OLD50
*-------------------------------------------------------------------------------
*                             save
SAVE$  MOV  10,1              ====
       BL   @GTP20            set vdp address
SAV10  BL   @RX1CH            |
       CI   6,>1600           |input chars untill <syn>
       JNE  SAV10             |
SAV20  SETO 9                 reset crc
SAV30  MOV  @>FF70(4),6       size (>8350)
       BL   @TXCRC            |
       SWPB 6                 |TRANSMIT 2 bytes (from r6)
       BL   @TXCRC            |
       BL   @TX2CH            TRANSMIT 2 bytes: crc
       BL   @RX1CH            |
       CI   6,>0600           |wait for <ack>
       JNE  SAV20             |
       MOV  @>FF70(4),7       size (>8350)
SAV40  BL   @NXREC            number of bytes
SAV50  SETO 9                 reset crc
       MOV  10,1              |
       BL   @GTP20            |set data buffer address (to read)
SAV60  MOVB @>FBFE(15),6
       BL   @TXCRC            TRANSMIT 1 byte
       DEC  7
       JNE  SAV60             next
       BL   @TX2CH            TRANSMIT crc (2 bytes)
       BL   @RX1CH            |
       CI   6,>0600           |fetch 1 char
       JEQ  SAV80             |is it <ack>?
SAV70  MOV  @>FF80(4),7       rec size (>8360)
       JMP  SAV50             retry
SAV80  AI   10,>0100
       MOV  @>FF7E(4),7       rec number (>835E)
       JMP  SAV40             next record
*------------------------------------------------------------------------------*
*           Correspondence between old and save                                *
*           -----------------------------------                                *
*                                                                              *
*          SAVE                 Bytes              OLD                         *
*                                                                              *
*      Emit <syn>               ---1->     Wait for <syn>                      *
*      Emit size     <-+        ---2->     Receive size        <-+             *
*      Emit crc        |        ---2->     Receive crc           |             *
*                      |                   Check if crc ok       |             *
*      Receive char or-+        <--1--      no:  TRANSMIT <nak> and -+             *
*      If not <ack>----+                    yes: TRANSMIT <ack>                    *
*                                                                              *
*      Emit 1 record <-+ <-+    -256->     Receive 1 record    <-+ <-+         *
*      Emit crc        |   |    ---2->     Receive crc           |   |         *
*                      |   |               Check if crc of       |   |         *
*      Receive char or-|   |    <--1--      no:  TRANSMIT <nak> and -+   |         *
*      If not <ack>----+   |                yes: TRANSMIT <ack>          |         *
*      Next record --------+               Next record  -------------+         *
*                                                                              *
*------------------------------------------------------------------------------*
ERR$2  LI   1,>4000           error code 2 :error in switch options
       JMP  STERR
ERR$3  LI   1,>6000           error code 3 :illegal command
       JMP  STERR
ERR$4  LI   1,>8000           error code 4 :memory full (rec too big)
       JMP  STERR
ERR$6  LI   1,>C000           error code 6 :hardware error / <clear>
STERR  SOCB 1,@>FF6B(4)       set error flags (>834B)
CLOSE  MOVB @HEX01,@MCR+W    *CLEAR RTS
       BL   @GTPAB            close
       DATA >4001             =====
       MOVB @>FF6B(4),@>FFFE(15) write status
       BL   @GTPAB            |
       DATA >4005             |write char count
       MOVB @>FF6F(4),@>FFFE(15)
       INCT @>FF84(4)         modify return address
CLS10  ANDI 12,>FF00          return
       MOV  @>FF84(4),11      ======
       RT
 
*==============================================================================*
* Subroutines used by DSRs                                                     *
*------------------------------------------------------------------------------*
*                             init dsr
INIT$  MOV  11,@>FF86(4)      --------
       BL   @SV$OL            is opcode save or old?
       JEQ  INI10
       LI   8,OPTBL           no -> tw=0 pa=o da=7  (00001010)
       LI   1,>0A00
       JMP  INI20
INI10  LI   8,OPT10           yes -> tw=0 pa=n da=8 (00000011)
       LI   1,>0300
INI20  LI   5,300            *default speed=300
       MOV  4,9               |
       AI   9,>FFFA           |control reg saved in >83DA
       MOVB 1,*9              |
       BL   @BAUDR5           find BAUD RATE
       MOVB @>FF73(4),0       name size (>8353)
       SRL  0,8
       S    @>FF74(4),0
       JLE  INI40             no .
       MOV  @>FF76(4),1       |
       BL   @GTP20            |address of name
       SETO 6
INI30  MOV  0,0               end of string?
       JEQ  INI40
       BL   @FNDCH            |find char following the .
       DATA '.'*256           |put it in r6
       JEQ  INI40             none
       MOV  8,7
       SRL  6,8
       MOVB @>FBFE(15),6      next char
       DEC  0
       SWPB 6                 two chars codes
INI35  MOV  *7+,1             code from list
       JEQ  INI55             end of list -> err 2
       MOV  *7+,2             address
       C    1,6
       JNE  INI35             next
       B    *2                code found
*
INI40  MOVB @>FF6A(4),1       opcode (>834A) = open
       JEQ  INI45
       BL   @SV$OL            opcode = save/old
       JNE  INI50
       BL   @PTNBR            write number 255
       MOV  @>FF6C(4),10      data buffer (>834C)
INI45  BL   @SETUP            init card + chips
INI50  JMP  TXC20             return
INI55  JMP  ERR$2             error 2
*
OP_EC  LI   1,>FF78           .EC : >8358
       JMP  OPC10
OP_CR  LI   1,>FF79           .CR : >8359
       JMP  OPC10
OP_LF  LI   1,>FF7A           .LF : >835A
       JMP  OPC10
OP_NU  LI   1,>FF7C           .NU : >835C
       JMP  OPC10
OP_CH  LI   1,>FF7B           .CH : >835B
OPC10  A    4,1
       SOCB @HFF00,*1         >FF
       JMP  OPTW5             loop to INI30
*
OP_BA  EQU  $                *.BA=
       BL   @BAUDR            calc delay
       JMP  OPTW5             loop
*
OP_PA  EQU  $                *.PA=
       BL   @FNDCH           *|find char following =
       DATA '='*256          *|put it in r6
       JEQ  INI55            *none -> err 2
       SZCB @HEX18,*9        *CLEAR PEN & EPS (NO PARITY)
       SRL  6,8
       CI   6,'N'            *N -> ...00...
       JEQ  OPTW5
       CI   6,'E'            *E -> ...11...
       JEQ  OPP10
       CI   6,'O'            *O -> ...01...
       JNE  INI55             other -> err 2
       SOCB @HEX08,*9         >08
       JMP  OPTW5
OPP10  SOCB @HEX18,*9         >18
       JMP  OPTW5
*
OP_DA  EQU  $                 .DA=
       BL   @FNDCH            |find char following =
       DATA '='*256           |put it in r6
       JEQ  INI55             none -> err 2
       BL   @GTNBR            read number
       SOCB @H0303,*9        *PRE-SET WORD LENGTH 8  
       AI   R5,-7    
       JEQ  OPD10
       DEC  R5                8 -> ......11
       JNE  INI55             other -> err 2
       JMP  OPD20
OPD10  SZCB @HEX01,*9         7 -> ......10  (>01)
OPD20  JMP  OPTW5
*
OP_TW  SZCB @HEX04,*9         .TW            (>04)
       SOCB @HEX04,*9         .....1..       (>04)
OPTW5  JMP  INI30             loop
*-------------------------------------------------------------------------------
RX2CH  MOV  11,@>FF86(4)      receive 2 bytes (in r8)
       BL   @RX1CH            ---------------
       MOV  6,8               fetch 1ST
       BL   @RX1CH
       SWPB 6                 fetch 2nd
       SOC  6,8
       JMP  TXC20
*-------------------------------------------------------------------------------
TX2CH  MOV  11,@>FF86(4)      TRANSMIT 2 bytes (from r9)
       MOV  9,6               ------------
       BL   @TX1R6            TRANSMIT 1ST
       SWPB 6
       BL   @TX1R6            TRANSMIT 2nd
       JMP  TXC20
*-------------------------------------------------------------------------------
RXCRC  MOV  11,@>FF86(4)      receive 1 byte (in r6)
       BL   @RX1CH            --------------
       JMP  TXC10             update crc
*-------------------------------------------------------------------------------
TXCRC  MOV  11,@>FF86(4)      TRANSMIT 1 byte (from r6)
       BL   @TX1R6            -----------
TXC10  BL   @UPCRC            update crc
TXC20  MOV  @>FF86(4),11      (>8366)
       RT
*-------------------------------------------------------------------------------
BAUDR  MOV  R11,@>FF88(4)    *delay calculation
       BL   @FNDCH           *-----------------
       DATA >3D00            *find char following =
       JEQ  INI55            *none -> err 2
       BL   @GTNBR           *read number
       CI   R6,1
       JLE  BAU20
       JMP  INI55
       
BAUDR5 MOV  11,@>FF88(4)     *(>8368)
BAU20  LI   1,BAUD$          *find baud rate
       CLR  R2
BAU30  MOV  *R1,R11          *GET BAUD RATE
       JEQ  INI55            *not found -> err 2
       C    R5,R11           *COMPARE WITH ".BA=" ARGUMENT
       JEQ  BAU40            *found
       C    *R1+,*R1+        *NEXT ENTRY
       JMP  BAU30            *next
BAU40  MOV  @2(1),@>FFFE(4)  *SET BAUD RATE (>83DE)
       JMP  RX1$G            *RETURN
*-------------------------------------------------------------------------------
RX1CH  MOV  11,@>FF88(4)      receive 1 byte
       MOVB @HEX03,@MCR+W    *SET RTS
RX1$A  BL   @RXRDY            --------------
       JEQ  RX1$B             test dsr pin and rec buffer or handshake in
       BL   @KBTST            no reception -> test <clear>
       JMP  RX1$A             loop
RX1$B  CLR  6                 COM1$
       MOVB @RBR,6           * DATA FROM RECEIVE BUFFER
       MOVB @HEX00,@IER+W    * INTERRUPT DISABLED
       MOVB @LSR,11
       COC  OEBIT,R11        * OVERFLOW? (NEW BIT ARRIVED TOO FAST)
       JEQ  RX1$C             yes: err 6
       COC  FEBIT,R11        * FRAME? (STOP BITS INTERPRETED AS 0)
       JEQ  RX1$C             yes: err 6
       MOVB @>FF7B(4),@>FF7B(4) check parity?
       JEQ  RX1$G             no
       COC  PEBIT,R11        * YES: PARITY ERROR?
       JNE  RX1$G             no
RX1$C  B    @ERR$6            yes: err 6

RX1$G  MOV  @>FF88(4),11     *RESTORE RETURN ADDRESS
       RT                    *RETRUN
PEBIT  DATA PE*256
FEBIT  DATA FE*256
OEBIT  DATA OE*256
*-------------------------------------------------------------------------------
NXREC  MOV  11,@>FF88(4)      next record
       MOVB 7,7               -----------
       JEQ  NXR10             last?
       BL   @PTN10            write rec number
       AI   7,>FF00
       MOV  7,@>FF7E(4)       save rec number in >835E
       LI   7,>0100           length 256 bytes
       JMP  NXR30
NXR10  MOV  7,7               last rec
       JNE  NXR20
       B    @CLOSE            end
NXR20  CLR  @>FF7E(4)         rec number =0
NXR30  MOV  7,@>FF80(4)       rec length in >8360
       JMP  RX1$G
*-------------------------------------------------------------------------------
PTNBR  SETO 7                 write decimal number
PTN10  MOV  11,@>FF8A(4)      --------------------
       CLR  1                 |
       BL   @GTP10            |set vdp address >0000 (to write)
       DATA >4000             |
       BL   @WR14S            write 14 spaces
       MOV  7,2               number to write
       SRL  2,8
       LI   6,100
PTN20  CLR  1
       DIV  6,1
       AI   1,>0030           digit 0-9 -> ascii code
       SLA  1,8
       AB   @>FF72(4),1       add bias (>8352)
       MOVB 1,@>FFFE(15)      write it
       CLR  5
       DIV  @DEC10,5          divide divisor by 10 (100->10->1->0)
       MOV  5,6
       JNE  PTN20             0? -> end
       BL   @WR14S            write 14 spaces
       JMP  EOR50             rt
*-------------------------------------------------------------------------------
EOREC  MOV  11,@>FF8A(4)      end of record
       MOVB @>FF79(4),11      -------------
       JNE  EOR50             .cr?
       BL   @TCHDT            |
       DATA >0D00             |no -> send <cr>
       JMP  EOR20
EOR10  MOV  11,@>FF8A(4)
EOR20  MOVB @>FF7C(4),1       .nu?
       JEQ  EOR40
       LI   5,>0006           |
EOR30  BL   @TCHDT            |
       DATA >0000             |yes -> send 6 >00
       DEC  5                 |
       JNE  EOR30             |
EOR40  MOVB @>FF79(4),1        no
       JNE  EOR50             .cr
       MOVB @>FF7A(4),1
       JNE  EOR50             .lf
       BL   @TCHDT            |neither .cr nor .lf
       DATA >0A00             |-> send <lf>
EOR50  MOV  @>FF8A(4),11
       RT
*-------------------------------------------------------------------------------
SV$OL  MOVB @>FF6A(4),1       opcode = save/old?
       SRL  1,8               ------------------
       AI   1,-5
       JEQ  SVO10             old  |
       DEC  1                 save |equ set
SVO10  RT
*-------------------------------------------------------------------------------
IN$DS  MOVB @>FF6B(4),1       int/dis?
       COC  H0008,1           --------   (>08)
       RT                     equ set if internal
*-------------------------------------------------------------------------------
FX$VR  MOVB @>FF6B(4),1       fix/var?
       ANDI 1,>1000           --------
       RT                     equ set if fixed
*-------------------------------------------------------------------------------
GTNBR  MOV  R11,@>FF8A(4)     read number (put it in r5)
       CLR  R1                -----------
       CLR  R11
       JMP  GTN20
GTN10  MOVB @>FBFE(15),R6     next char
       DEC  R0
GTN20  MOV  R6,R7
       SRL  R7,R8
       AI   R7,->30           char -> digit
       JLT  GTN30             below 0
       CI   R7,9
       JH   GTN30             above 9
       INC  R11               count digits
       MPY  @DEC10,R1         multiply number by 10
       MOV  R1,R5
       A    R7,R2             add digit to number
       JNC  GTN25
       INC  R5
GTN25  MOV  R2,R1
       MOV  R0,R0             end of string?
       JNE  GTN10             no -> loop
GTN30  MOV  R11,R11
       JNE  GTN50
GTN40  B    @ERR$2            no digits -> err 2
GTN50  MOV  R5,R6
       MOV  R1,R5
       MOV  @>FF8A(4),R11
       RT
DEC10  DATA 10
*-------------------------------------------------------------------------------
FNDCH  MOV  *11+,5            find char following sep
       CB   5,6               -----------------------
       JEQ  FND20             current char = separator
FND10  MOVB @>FBFE(15),6      next char
       DEC  0
       CB   5,6
       JEQ  FND20             char = separator
       MOV  0,0
       JNE  FND10             loop if not end of string
FND20  MOV  0,0               sep found
       JEQ  FND30             end of string
       CLR  6
       MOVB @>FBFE(15),6      read next char
       DEC  0
       CI   6,>2000
       JEQ  FND20             skip if it is a space
FND30  RT               equ set if not found
*-------------------------------------------------------------------------------
UPCRC  MOV  6,1               update crc
       ANDI 1,>FF00           ----------
       XOR  1,9               new char in r6
       MOV  9,1               crc in r9
       SRL  1,4
       XOR  9,1
       ANDI 1,>FF00
       SRL  1,4
       XOR  1,9
       SRC  1,7
       XOR  1,9
       SWPB 9
       RT
*-------------------------------------------------------------------------------
TX1VR  MOVB @>FBFE(15),R6    *TRANSMIT 1 CHAR (from r6)
       JMP  TX1R6             -----------
TCHDT  MOV  *11+,6            ITEM from data
TX1R6  MOV  11,@>FF8C(4)
TCH30  MOVB @HEX03,@MCR+W    * SET RTS & DTR
       MOVB @MSR,R11         * TEST CTS 
       COC  CTSBIT,R11
       JEQ  TCH60
       BL   @KBTST
       JMP  TCH30
TCH60  MOVB @LSR,R11
       COC  TEMTBT,R11
       JNE  TCH80
TCH70  BL   @KBTST            not empty ->test <clear> key
       JMP  TCH30             loop
TCH80  MOVB 6,@THR              * buffer empty -> load it with new char
TCH90  MOV  @>FF8C(4),11
       RT
CTSBIT DATA CTS*256 
TEMTBT DATA TEMT*256
*-------------------------------------------------------------------------------
SETUP  EQU  $
*      SBO  31                rs232 reset chip
       MOVB @HEX80,@LCR+W    *setup communications SET DLAB
       MOVB @>FFFF(4),@DLL+W * load DLL/DLM (>83DE)
       MOVB @>FFFE(4),@DLM+W
       MOVB @>FFFA(4),@LCR+W * load LCR (>83DA)
       MOVB @HEX06,@FCR+W    * RESET FIFOS
       MOVB @HEX00,@FCR+W
       MOVB @HEX01,@MCR+W    * SET DTR, CLEAR RTS & AFE
       MOVB @>FF7D(4),1      *opcode = >80? (>835D)
       JEQ  SET20
*      SBO  18                yes -> interrupts enabled
*      LI   3,ERBI*256
*      MOVB 3,@IER+W            * YES -> INTERRUPTS ENABLED
SET20  RT
*-------------------------------------------------------------------------------
GTPAB  MOV  @>FF76(4),1       find beg of pab
       S    @>FF74(4),1       ---------------
       AI   1,>FFF6           >8356 - >8354(size) - 10
GTP10  A    *11+,1            offset in data
GTP20  MOVB @>0003(4),*15     set vdp address
       NOP                    ---------------
       MOVB 1,*15
       RT
*-------------------------------------------------------------------------------
WR14S  LI   1,>2020           write 14 spaces
       AB   @>FF72(4),1       ---------------
       LI   2,>000E           adding bias (>8352)
WR14A  MOVB 1,@>FFFE(15)
       DEC  2
       JNE  WR14A
       RT
*-------------------------------------------------------------------------------
RXRDY  EQU  $                *CHECK FOR RX AVAIL
       MOVB @LSR,R3
       COC  DR_BIT,R3        *TEST DATA READY
       CLR  R3
RXR90  RT                    *equ set if 1 byte has arrived
*-------------------------------------------------------------------------------
KBTST  MOV  12,1              test <clear> key
       LI   12,>0024          ----------------
       LDCR @HEX00,3          >00
       TB   -11               fctn?
       JEQ  KBT10
       LDCR @H0303,3          >03
       TB   -11               <4>
       JNE  KBT20
KBT10  MOV  R1,R12           *not pressed
       RT
KBT20  MOV  R1,R12           *pressed
       MOVB @HEX01,@MCR+W    *CLEAR RTS
       B    @ERR$6            error 6
HEX30  BYTE >30
HEXE0  BYTE >E0
HEX80  BYTE >80
HEX01  BYTE >01
HEX04  BYTE >04
HEX18  BYTE >18
HEX08  BYTE >04
HEX22  BYTE >22
HEXC1  BYTE >C1
HEX03  BYTE >03
       EVEN
DSRBIT DATA DSR*256      
DR_BIT DATA DR*256
SLAST  EQU  $
      END

