
# Postprocessing der DSR Assemblierung
# CW 20251013

import sys   # Fuer den Zugriff auf Kommandozeilenargumente
import os    # Fuer Dateipfad- und Skriptinformationen

def fill_and_save(input_file1, input_file2, output_file, target_size_kb=8):

    target_size = target_size_kb * 1024

    try:
        with open(input_file1, 'rb') as f:
            data1 = f.read()

        with open(input_file2, 'rb') as f:
            data2 = f.read()

        current_size1 = len(data1)
        current_size2 = len(data2)

        # Wenn die Datei groesser als die Zielgroesse ist, wird abgebrochen
        if current_size1 > target_size:
            print(f"Die Datei {input_file1} ist groesser als {target_size} Bytes.")
            return
        if current_size2 > target_size:
            print(f"Die Datei {input_file2} ist groesser als {target_size} Bytes.")
            return

        # Berechnet, wie viele Bytes bis zur Zielgroesse fehlen
        fill_size1 = target_size - current_size1

        # Erstellt eine Bytefolge mit der gewuenschten Anzahl an 0xFF-Bytes
        fill_data = b'\xFF' * fill_size1

        new_data = data1 + fill_data

        fill_size2 = target_size - current_size2
        fill_data = b'\xFF' * fill_size2
        new_data = new_data + data2 + fill_data

        with open(output_file, 'wb') as f:
            f.write(new_data)

        print(f"Datei erfolgreich geschrieben: {output_file} ({len(new_data)} Bytes)")
        print(f"Datei 1 um {fill_size1} Bytes erweitert, Datei 2 um {fill_size2} Bytes erweitert")

    except FileNotFoundError:
        print(f"Fehler: Datei '{input_file1}' oder '{input_file2}' nicht gefunden.")

    except Exception as e:
        print(f"Ein Fehler ist aufgetreten: {e}")

# Prueft, ob das Skript direkt (nicht als Modul) ausgefuehrt wird
if __name__ == "__main__":
    script_name = os.path.basename(sys.argv[0])
    print(f"{script_name} - Binaerfiles auf 8192 Bytes erweitern und kombinieren - Ch. Winter 2025-10-13")

    if len(sys.argv) != 4:
        print(f"Verwendung: {{python}} {script_name} <eingabedatei 1> <eingabedatei 2> <ausgabedatei>")
        sys.exit(1)

    # Liest die Dateinamen aus den Kommandozeilenargumenten
    input_filename1 = sys.argv[1]
    input_filename2 = sys.argv[2]
    output_filename = sys.argv[3]

    fill_and_save(input_filename1, input_filename2, output_filename)
