--------------------------------------------------------------------------------
-- P R O D U C T I O N  - nanoPEB using TMS9902
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;


entity nanoPEB_SIO is
    Port ( 
        A         :  in std_logic_vector(0 to 9); -- A0 - A9
        A_LOW     :  in std_logic_vector(12 to 14); -- A12 - A14
        nMEMEN    :  in std_logic;
        nCRUCLK   :  in std_logic;
        nPH3CLK   :  in std_logic;
        DBIN      :  in std_logic;
        CRUINBF   :  in std_logic;
        nINT      :  in std_logic;
        A15       :  in std_logic;
        CRUOUT    :  out std_logic;
        n9902     :  buffer std_logic;
        nEXTINT   :  out std_logic;
        nPH3CLKBF :  out std_logic;
        CRUCLK    :  out std_logic;
        nRAM      :  out std_logic;
        nROM      :  out std_logic;
        nIDE      :  out std_logic;
        nRAM2     :  out std_logic;
        A0_A2     :  out std_logic;
        CRUIN     :  out std_logic;
        BANK      :  buffer std_logic_vector(0 to 2)
      );
end nanoPEB_SIO;

architecture Behavioral of nanoPEB_SIO is
  signal RAM2Flag   :  std_logic;
  signal Int        :  std_logic := '0';
begin

  -------------
  -- Buffers --
  -------------
  nPH3CLKBF <= nPH3CLK;
  BANK(2) <= '0';
  CRUOUT <= A15;

  process(BANK,A,nCRUCLK)
  begin
    if BANK(1) = '1' and A = "0001001101" and nCRUCLK = '1' then     -->1340
      n9902 <=  '0';
      CRUCLK <= '0';
    elsif BANK(1) = '1' and A = "0001001101"  and nCRUCLK = '0' then -->1340
      n9902 <= '0';
      CRUCLK <= '1';
    else 
      n9902 <= '1';
      CRUCLK <= '0';
    end if;
  end process;

  process (A,A_LOW,nCRUCLK,A15)
  begin
    if nCRUCLK = '0' and A = "0001000100" and A_LOW = "000" then     -->1100
      BANK(0) <= A15;
    elsif nCRUCLK = '0' and A = "0001000100" and A_LOW = "001" then  -->1102
      RAM2Flag <= A15;
    elsif nCRUCLK = '0' and A = "0001001100" and A_LOW = "000" then  -->1300
      BANK(1) <= A15;
    elsif nCRUCLK = '0' and A = "0001001100" and A_LOW = "001" then  -->1302
      Int <= A15; 
    end if;
  end process;
  
  process (nMEMEN,A,BANK,RAM2Flag,DBIN)
  begin
    if ((A = "0101111110" and DBIN = '1') or (A = "0101111111" and DBIN = '0')) and 
          BANK(0) = '1' and 
          nMEMEN = '0' and
          A15 = '1' then
      -----------
      -- nIDE  --
      -----------
      nIDE <= '0'; 
      nROM <= '1';
      nRAM <= '1';
      nRAM2 <= '1'; 
    elsif (A >= "0100000000" and A < "0101111110") and 
          (BANK(0) = '1' or BANK(1) = '1') and 
          nMEMEN = '0' and 
          DBIN = '1' then
      -----------
      -- nROM  --
      -----------
      nROM <= '0';
      nRAM <= '1';
      nRAM2 <= '1'; 
      nIDE <= '1';
    elsif nMEMEN = '0' and
          (A(0 to 2) = "001" or 
           A(0 to 2) = "101" or 
           A(0 to 2) = "110" or 
           A(0 to 2) = "111") then
      if RAM2Flag = '1' then
        -----------
        -- nRAM2 --
        -----------
        nRAM <= '1';
        nRAM2 <= '0';
      else
        -----------
        -- nRAM  --
        -----------
        nRAM2 <= '1';
        nRAM <= '0';
      end if;
      nROM <= '1';
      nIDE <= '1';
    else 
      nROM <= '1';
      nRAM <= '1';
      nRAM2 <= '1'; 
      nIDE <= '1';
    end if;
  end process;
  
  nEXTINT <= nINT OR (not Int);
--    when BANK(1) = '1' and nPH3CLK = '0' and nINT = '1'
--    else 'Z';

  -----------
  -- A0_A2 --
  -----------
  A0_A2 <= A(0) and A(2);

  -------------
  -- CRU IN  --
  -------------
  CRUIN <= BANK(0) when A = "0001000100" and A_LOW = "000" else  -->1100
           RAM2Flag when A = "0001000100" and A_LOW = "001" else -->1102
           BANK(1) when A = "0001001100" and A_LOW = "000" else  -->1300
           CRUINBF when A = "0001001101" and BANK(1) = '1' else  -->1340
           'Z';

end Behavioral;
